/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationItem;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class UnevaluatedPropertiesEvaluator
implements Evaluator {
    private final String schemaRef;
    private final String parentPath;

    UnevaluatedPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        String schemaPointer = node.getJsonPointer();
        this.schemaRef = ctx.getAbsoluteUri(schemaPointer);
        this.parentPath = UriUtil.getJsonPointerParent(schemaPointer);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.UNEVALUATED_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        List evaluationItems = Collections.unmodifiableList(ctx.getAnnotations().stream().filter(a -> this.getSchemaPath((EvaluationItem)a).startsWith(this.parentPath)).collect(Collectors.toList()));
        List array = node.asObject().values().stream().filter(propertyNode -> evaluationItems.stream().noneMatch(a -> a.getInstanceLocation().startsWith(propertyNode.getJsonPointer()))).collect(Collectors.toList());
        boolean valid = array.stream().filter(propertyNode -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)propertyNode)).count() == (long)array.size();
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 20;
    }

    private String getSchemaPath(EvaluationItem item) {
        return UriUtil.getJsonPointer(item.getSchemaLocation());
    }
}

