/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class Schema {
    private static final Evaluator TRUE_EVALUATOR = (ctx, node) -> Evaluator.Result.success();
    private static final Evaluator FALSE_EVALUATOR = (ctx, node) -> Evaluator.Result.failure("False schema always fails");
    private final URI parentUri;
    private final String schemaLocation;
    private final List<EvaluatorWrapper> evaluators;
    private final Set<String> activeVocabularies;
    private final Map<String, Boolean> vocabulariesObject;

    Schema(URI parentUri, String schemaLocation, List<EvaluatorWrapper> evaluators, Set<String> activeVocabularies, Map<String, Boolean> vocabulariesObject) {
        this.parentUri = parentUri;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        this.activeVocabularies = Objects.requireNonNull(activeVocabularies);
        this.vocabulariesObject = Objects.requireNonNull(vocabulariesObject);
        ArrayList<EvaluatorWrapper> unsortedEvaluators = new ArrayList<EvaluatorWrapper>((Collection)Objects.requireNonNull(evaluators));
        unsortedEvaluators.sort(Comparator.comparingInt(Evaluator::getOrder));
        this.evaluators = Collections.unmodifiableList(unsortedEvaluators);
    }

    static Evaluator getBooleanEvaluator(boolean val) {
        return val ? TRUE_EVALUATOR : FALSE_EVALUATOR;
    }

    URI getParentUri() {
        return this.parentUri;
    }

    String getSchemaLocation() {
        return this.schemaLocation;
    }

    List<EvaluatorWrapper> getEvaluators() {
        return this.evaluators;
    }

    Set<String> getActiveVocabularies() {
        return this.activeVocabularies;
    }

    Map<String, Boolean> getVocabulariesObject() {
        return this.vocabulariesObject;
    }
}

