/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Optional;
import java.util.Set;

class IfThenElseEvaluator
implements Evaluator {
    private final String ifRef;
    private final Optional<String> thenRef;
    private final Optional<String> elseRef;

    IfThenElseEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.ifRef = ctx.getAbsoluteUri(node);
        this.thenRef = Optional.ofNullable(ctx.getCurrentSchemaObject().get("then")).map(ctx::getAbsoluteUri);
        this.elseRef = Optional.ofNullable(ctx.getCurrentSchemaObject().get("else")).map(ctx::getAbsoluteUri);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (ctx.resolveInternalRefAndValidate(this.ifRef, node)) {
            boolean valid = this.thenRef.map(ref -> ctx.resolveInternalRefAndValidate((String)ref, node)).orElse(true);
            return valid ? Evaluator.Result.success() : Evaluator.Result.failure("Value matches against schema from 'if' but does not match against schema from 'then'");
        }
        boolean valid = this.elseRef.map(ref -> ctx.resolveInternalRefAndValidate((String)ref, node)).orElse(true);
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure("Value does not match against schema from 'if' and 'else'");
    }
}

