/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompositeEvaluatorFactory;
import dev.harrel.jsonschema.CompositeSchemaResolver;
import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Dialects;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.providers.JacksonNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ValidatorFactory {
    private Dialect dialect = new Dialects.Draft2020Dialect();
    private EvaluatorFactory evaluatorFactory;
    private Supplier<JsonNodeFactory> jsonNodeFactory = JacksonNode.Factory::new;
    private SchemaResolver schemaResolver = new DefaultSchemaResolver();
    private boolean disabledSchemaValidation = false;

    public Validator createValidator() {
        EvaluatorFactory compositeFactory = this.evaluatorFactory == null ? this.dialect.getEvaluatorFactory() : CompositeEvaluatorFactory.of(this.evaluatorFactory, this.dialect.getEvaluatorFactory());
        JsonNodeFactory nodeFactory = this.jsonNodeFactory.get();
        SchemaRegistry schemaRegistry = new SchemaRegistry();
        MetaSchemaValidator metaSchemaValidator = this.disabledSchemaValidation ? new MetaSchemaValidator.NoOpMetaSchemaValidator(this.dialect.getSupportedVocabularies()) : new MetaSchemaValidator.DefaultMetaSchemaValidator(this.dialect, nodeFactory, schemaRegistry, this.schemaResolver);
        return new Validator(this.dialect, compositeFactory, nodeFactory, this.schemaResolver, schemaRegistry, metaSchemaValidator);
    }

    public ValidatorFactory withDialect(Dialect dialect) {
        this.dialect = Objects.requireNonNull(dialect);
        return this;
    }

    public ValidatorFactory withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        return this;
    }

    public ValidatorFactory withJsonNodeFactory(JsonNodeFactory jsonNodeFactory) {
        Objects.requireNonNull(jsonNodeFactory);
        this.jsonNodeFactory = () -> jsonNodeFactory;
        return this;
    }

    public ValidatorFactory withSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = CompositeSchemaResolver.of(Objects.requireNonNull(schemaResolver), new DefaultSchemaResolver());
        return this;
    }

    public ValidatorFactory withDisabledSchemaValidation(boolean disabledSchemaValidation) {
        this.disabledSchemaValidation = disabledSchemaValidation;
        return this;
    }

    public Validator.Result validate(String rawSchema, String rawInstance) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(Object schemaProviderNode, String rawInstance) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(JsonNode schemaNode, String rawInstance) {
        return this.validate(schemaNode, this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(String rawSchema, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(Object schemaProviderNode, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(JsonNode schemaNode, Object instanceProviderNode) {
        return this.validate(schemaNode, this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(String rawSchema, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), instanceNode);
    }

    public Validator.Result validate(Object schemaProviderNode, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), instanceNode);
    }

    public Validator.Result validate(JsonNode schemaNode, JsonNode instanceNode) {
        Validator validator = this.createValidator();
        URI uri = validator.registerSchema(schemaNode);
        return validator.validate(uri, instanceNode);
    }

    static class DefaultSchemaResolver
    implements SchemaResolver {
        private final Map<String, String> schemaCache = new HashMap<String, String>();

        DefaultSchemaResolver() {
        }

        @Override
        public SchemaResolver.Result resolve(String uri) {
            if (this.schemaCache.containsKey(uri)) {
                return SchemaResolver.Result.fromString(this.schemaCache.get(uri));
            }
            Optional<String> rawSchema = Arrays.stream(SpecificationVersion.values()).filter(spec -> spec.getId().equals(uri)).map(SpecificationVersion::getResourcePath).map(path -> {
                try (InputStream is = this.getClass().getResourceAsStream((String)path);){
                    if (is == null) {
                        String string2 = null;
                        return string2;
                    }
                    String string = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining());
                    return string;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).findFirst();
            rawSchema.ifPresent(s -> this.schemaCache.put(uri, (String)s));
            return rawSchema.map(SchemaResolver.Result::fromString).orElse(SchemaResolver.Result.empty());
        }
    }
}

