/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Error;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationItem;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public final class Validator {
    private final JsonNodeFactory jsonNodeFactory;
    private final SchemaResolver schemaResolver;
    private final SchemaRegistry schemaRegistry;
    private final JsonParser jsonParser;

    Validator(Dialect dialect, EvaluatorFactory evaluatorFactory, JsonNodeFactory jsonNodeFactory, SchemaResolver schemaResolver, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.schemaRegistry = schemaRegistry;
        this.jsonParser = new JsonParser(dialect, evaluatorFactory, this.schemaRegistry, metaSchemaValidator);
    }

    public URI registerSchema(String rawSchema) {
        return this.registerSchema(this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(Object schemaProviderNode) {
        return this.registerSchema(this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(this.generateSchemaUri(), schemaNode);
    }

    public URI registerSchema(URI uri, String rawSchema) {
        return this.registerSchema(uri, this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(URI uri, Object schemaProviderNode) {
        return this.registerSchema(uri, this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(URI uri, JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(uri, schemaNode);
    }

    public Result validate(URI schemaUri, String rawInstance) {
        return this.validate(schemaUri, this.jsonNodeFactory.create(rawInstance));
    }

    public Result validate(URI schemaUri, Object instanceProviderNode) {
        return this.validate(schemaUri, this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public Result validate(URI schemaUri, JsonNode instanceNode) {
        Schema schema = this.getRootSchema(schemaUri.toString());
        EvaluationContext ctx = this.createNewEvaluationContext(schema);
        boolean valid = ctx.validateAgainstSchema(schema, instanceNode);
        return Result.fromEvaluationContext(valid, ctx);
    }

    private Schema getRootSchema(String uri) {
        Schema schema = this.schemaRegistry.get(uri);
        if (schema == null) {
            throw new SchemaNotFoundException(uri);
        }
        return schema;
    }

    private URI generateSchemaUri() {
        return URI.create("https://harrel.dev/" + UUID.randomUUID().toString().substring(0, 8));
    }

    private EvaluationContext createNewEvaluationContext(Schema schema) {
        return new EvaluationContext(this.jsonNodeFactory, this.jsonParser, this.schemaRegistry, this.schemaResolver, schema.getActiveVocabularies());
    }

    public static final class Result {
        private final boolean valid;
        private final List<EvaluationItem> evaluationItems;
        private final List<EvaluationItem> validationItems;

        Result(boolean valid, List<EvaluationItem> evaluationItems, List<EvaluationItem> validationItems) {
            this.valid = valid;
            this.evaluationItems = Objects.requireNonNull(evaluationItems);
            this.validationItems = Objects.requireNonNull(validationItems);
        }

        static Result fromEvaluationContext(boolean valid, EvaluationContext ctx) {
            return new Result(valid, Collections.unmodifiableList(new ArrayList<EvaluationItem>(ctx.getEvaluationItems())), Collections.unmodifiableList(new ArrayList<EvaluationItem>(ctx.getValidationItems())));
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<Annotation> getAnnotations() {
            return Collections.unmodifiableList(this.evaluationItems.stream().filter(a -> a.getAnnotation() != null).collect(Collectors.toList()));
        }

        public List<Error> getErrors() {
            if (this.isValid()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.validationItems.stream().filter(a -> !a.isValid()).filter(a -> a.getError() != null).collect(Collectors.toList()));
        }
    }
}

