/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationItem;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class UnevaluatedPropertiesEvaluator
implements Applicator {
    private final String schemaRef;
    private final String parentPath;

    UnevaluatedPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        String schemaPointer = node.getJsonPointer();
        this.schemaRef = ctx.getAbsoluteUri(schemaPointer);
        this.parentPath = UriUtil.getJsonPointerParent(schemaPointer);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.UNEVALUATED_VOCABULARY;
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        List evaluationItems = Collections.unmodifiableList(ctx.getEvaluationItems().stream().filter(a -> this.getSchemaPath((EvaluationItem)a).startsWith(this.parentPath)).collect(Collectors.toList()));
        return node.asObject().values().stream().filter(propertyNode -> evaluationItems.stream().noneMatch(a -> a.getInstanceLocation().startsWith(propertyNode.getJsonPointer()))).allMatch(propertyNode -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)propertyNode));
    }

    @Override
    public int getOrder() {
        return 20;
    }

    private String getSchemaPath(EvaluationItem item) {
        return UriUtil.getJsonPointer(item.getSchemaLocation());
    }
}

