/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SchemaRegistry {
    private State state = State.access$000();

    SchemaRegistry() {
    }

    State createSnapshot() {
        return State.copyOf(this.state);
    }

    void restoreSnapshot(State state) {
        this.state = state;
    }

    Schema get(String uri) {
        return this.state.schemas.getOrDefault(uri, (Schema)this.state.additionalSchemas.get(uri));
    }

    Schema getDynamic(String anchor) {
        return (Schema)this.state.dynamicSchemas.get(anchor);
    }

    void registerSchema(SchemaParsingContext ctx, JsonNode schemaNode, List<EvaluatorWrapper> evaluators, Set<String> activeVocabularies) {
        Schema schema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), evaluators, activeVocabularies, ctx.getVocabulariesObject());
        this.state.schemas.put(ctx.getAbsoluteUri(schemaNode), schema);
        this.registerAnchorsIfPresent(ctx, schemaNode, schema);
    }

    void registerIdentifiableSchema(SchemaParsingContext ctx, URI id, JsonNode schemaNode, List<EvaluatorWrapper> evaluators, Set<String> activeVocabularies) {
        String absoluteUri = ctx.getAbsoluteUri(schemaNode);
        this.state.schemas.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(absoluteUri)).forEach(e -> {
            int normalizedUriSize = absoluteUri.endsWith("/") ? absoluteUri.length() - 1 : absoluteUri.length();
            String newJsonPointer = ((String)e.getKey()).substring(normalizedUriSize);
            String newUri = id.toString() + "#" + newJsonPointer;
            this.state.additionalSchemas.put(newUri, (Schema)e.getValue());
        });
        Schema identifiableSchema = new Schema(ctx.getParentUri(), absoluteUri, evaluators, activeVocabularies, ctx.getVocabulariesObject());
        this.state.schemas.put(id.toString(), identifiableSchema);
        this.state.schemas.put(absoluteUri, identifiableSchema);
        this.registerAnchorsIfPresent(ctx, schemaNode, identifiableSchema);
    }

    private void registerAnchorsIfPresent(SchemaParsingContext ctx, JsonNode schemaNode, Schema schema) {
        JsonNode dynamicAnchorNode;
        if (!schemaNode.isObject()) {
            return;
        }
        Map<String, JsonNode> objectMap = schemaNode.asObject();
        JsonNode anchorNode = objectMap.get("$anchor");
        if (anchorNode != null && anchorNode.isString()) {
            String anchorFragment = "#" + anchorNode.asString();
            String anchoredUri = UriUtil.resolveUri(ctx.getParentUri(), anchorFragment);
            this.state.additionalSchemas.put(anchoredUri, schema);
        }
        if ((dynamicAnchorNode = objectMap.get("$dynamicAnchor")) != null && dynamicAnchorNode.isString()) {
            String anchorFragment = "#" + dynamicAnchorNode.asString();
            this.state.dynamicSchemas.put(ctx.getParentUri().toString() + anchorFragment, schema);
        }
    }

    static final class State {
        private final Map<String, Schema> schemas;
        private final Map<String, Schema> additionalSchemas;
        private final Map<String, Schema> dynamicSchemas;

        private State(Map<String, Schema> schemas, Map<String, Schema> additionalSchemas, Map<String, Schema> dynamicSchemas) {
            this.schemas = new HashMap<String, Schema>(schemas);
            this.additionalSchemas = new HashMap<String, Schema>(additionalSchemas);
            this.dynamicSchemas = new HashMap<String, Schema>(dynamicSchemas);
        }

        private static State empty() {
            return new State(new HashMap<String, Schema>(), new HashMap<String, Schema>(), new HashMap<String, Schema>());
        }

        private static State copyOf(State other) {
            return new State(new HashMap<String, Schema>(other.schemas), new HashMap<String, Schema>(other.additionalSchemas), new HashMap<String, Schema>(other.dynamicSchemas));
        }

        static /* synthetic */ State access$000() {
            return State.empty();
        }
    }
}

