/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.SchemaRegistry;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public final class SchemaParsingContext {
    private final Dialect dialect;
    private final URI baseUri;
    private final URI parentUri;
    private final SchemaRegistry schemaRegistry;
    private final Map<String, JsonNode> currentSchemaObject;

    private SchemaParsingContext(Dialect dialect, URI baseUri, URI parentUri, SchemaRegistry schemaRegistry, Map<String, JsonNode> currentSchemaObject) {
        this.dialect = dialect;
        this.baseUri = baseUri;
        this.parentUri = parentUri;
        this.schemaRegistry = schemaRegistry;
        this.currentSchemaObject = currentSchemaObject;
    }

    SchemaParsingContext(Dialect dialect, SchemaRegistry schemaRegistry, String baseUri, Map<String, JsonNode> currentSchemaObject) {
        this(dialect, URI.create(baseUri), URI.create(baseUri), schemaRegistry, currentSchemaObject);
    }

    SchemaParsingContext withParentUri(URI parentUri) {
        return new SchemaParsingContext(this.dialect, this.baseUri, parentUri, this.schemaRegistry, this.currentSchemaObject);
    }

    SchemaParsingContext withCurrentSchemaContext(Map<String, JsonNode> currentSchemaObject) {
        return new SchemaParsingContext(this.dialect, this.baseUri, this.parentUri, this.schemaRegistry, Collections.unmodifiableMap(currentSchemaObject));
    }

    Map<String, Boolean> getVocabulariesObject() {
        return JsonParser.getVocabulariesObject(this.currentSchemaObject).orElse(this.dialect.getDefaultVocabularyObject());
    }

    public URI getParentUri() {
        return this.parentUri;
    }

    public String getAbsoluteUri(JsonNode node) {
        return this.getAbsoluteUri(node.getJsonPointer());
    }

    public String getAbsoluteUri(String jsonPointer) {
        return this.baseUri + "#" + jsonPointer;
    }

    public Map<String, JsonNode> getCurrentSchemaObject() {
        return Collections.unmodifiableMap(this.currentSchemaObject);
    }
}

