/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.StringNode;

class PropertyNamesEvaluator
implements Applicator {
    private final String schemaRef;

    PropertyNamesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        return node.asObject().keySet().stream().allMatch(propName -> ctx.resolveInternalRefAndValidate(this.schemaRef, new StringNode((String)propName, node.getJsonPointer())));
    }
}

