/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonSchemaException;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SchemaRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class JsonParser {
    private final Dialect dialect;
    private final EvaluatorFactory evaluatorFactory;
    private final SchemaRegistry schemaRegistry;
    private final MetaSchemaValidator metaSchemaValidator;

    JsonParser(Dialect dialect, EvaluatorFactory evaluatorFactory, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator) {
        this.dialect = dialect;
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.metaSchemaValidator = Objects.requireNonNull(metaSchemaValidator);
    }

    URI parseRootSchema(URI baseUri, JsonNode node) {
        Optional<Map<String, JsonNode>> objectMapOptional = this.getAsObject(node);
        String metaSchemaUri = objectMapOptional.map(obj -> (JsonNode)obj.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString).orElse(this.dialect.getMetaSchema());
        Optional<String> providedSchemaId = objectMapOptional.map(obj -> (JsonNode)obj.get("$id")).filter(JsonNode::isString).map(JsonNode::asString).filter(id -> !baseUri.toString().equals(id));
        MetaValidationResult metaValidationResult = this.validateSchemaOrPostpone(node, metaSchemaUri, baseUri.toString(), providedSchemaId);
        if (node.isBoolean()) {
            SchemaParsingContext ctx = new SchemaParsingContext(this.dialect, this.schemaRegistry, baseUri.toString(), Collections.emptyMap());
            List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, Schema.getBooleanEvaluator(node.asBoolean())));
            this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, evaluators, metaValidationResult.activeVocabularies);
        } else if (objectMapOptional.isPresent()) {
            Map<String, JsonNode> objectMap = objectMapOptional.get();
            if (providedSchemaId.isPresent()) {
                String idString = providedSchemaId.get();
                SchemaParsingContext ctx = new SchemaParsingContext(this.dialect, this.schemaRegistry, idString, objectMap);
                List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
                this.schemaRegistry.registerIdentifiableSchema(ctx, URI.create(idString), node, evaluators, metaValidationResult.activeVocabularies);
            }
            SchemaParsingContext ctx = new SchemaParsingContext(this.dialect, this.schemaRegistry, baseUri.toString(), objectMap);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, evaluators, metaValidationResult.activeVocabularies);
        }
        metaValidationResult.performPostponedSchemaValidation(node, metaSchemaUri, baseUri.toString(), providedSchemaId);
        return providedSchemaId.map(URI::create).orElse(baseUri);
    }

    private Optional<Map<String, JsonNode>> getAsObject(JsonNode node) {
        return node.isObject() ? Optional.of(node.asObject()) : Optional.empty();
    }

    private void parseNode(SchemaParsingContext ctx, JsonNode node) {
        if (node.isBoolean()) {
            this.parseBoolean(ctx, node);
        } else if (node.isArray()) {
            this.parseArray(ctx, node);
        } else if (node.isObject()) {
            this.parseObject(ctx, node);
        }
    }

    private void parseBoolean(SchemaParsingContext ctx, JsonNode node) {
        boolean schemaValue = node.asBoolean();
        Evaluator booleanEvaluator = Schema.getBooleanEvaluator(schemaValue);
        List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, booleanEvaluator));
        this.schemaRegistry.registerSchema(ctx, node, evaluators, this.dialect.getSupportedVocabularies());
    }

    private void parseArray(SchemaParsingContext ctx, JsonNode node) {
        for (JsonNode element : node.asArray()) {
            this.parseNode(ctx, element);
        }
    }

    private void parseObject(SchemaParsingContext ctx, JsonNode node) {
        Map<String, JsonNode> objectMap = node.asObject();
        String metaSchemaUri = Optional.ofNullable(objectMap.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString).orElse(null);
        Optional<String> providedSchemaId = Optional.ofNullable(objectMap.get("$id")).filter(JsonNode::isString).map(JsonNode::asString);
        String absoluteUri = ctx.getAbsoluteUri(node);
        MetaValidationResult metaValidationResult = this.validateSchemaOrPostpone(node, metaSchemaUri, absoluteUri, providedSchemaId);
        if (providedSchemaId.isPresent()) {
            String idString = providedSchemaId.get();
            URI uri = ctx.getParentUri().resolve(idString);
            SchemaParsingContext newCtx = ctx.withParentUri(uri);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(newCtx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerIdentifiableSchema(newCtx, uri, node, evaluators, metaValidationResult.activeVocabularies);
        } else {
            this.schemaRegistry.registerSchema(ctx, node, this.parseEvaluators(ctx, objectMap, node.getJsonPointer()), metaValidationResult.activeVocabularies);
        }
        metaValidationResult.performPostponedSchemaValidation(node, metaSchemaUri, absoluteUri, providedSchemaId);
    }

    private List<EvaluatorWrapper> parseEvaluators(SchemaParsingContext ctx, Map<String, JsonNode> object, String objectPath) {
        SchemaParsingContext newCtx = ctx.withCurrentSchemaContext(object);
        ArrayList<EvaluatorWrapper> evaluators = new ArrayList<EvaluatorWrapper>();
        for (Map.Entry<String, JsonNode> entry : object.entrySet()) {
            this.evaluatorFactory.create(newCtx, entry.getKey(), entry.getValue()).map(evaluator -> new EvaluatorWrapper((String)entry.getKey(), (JsonNode)entry.getValue(), (Evaluator)evaluator)).ifPresent(evaluators::add);
            this.parseNode(newCtx, entry.getValue());
        }
        if (evaluators.isEmpty()) {
            evaluators.add(new EvaluatorWrapper(null, objectPath, Schema.getBooleanEvaluator(true)));
        }
        return evaluators;
    }

    static Optional<Map<String, Boolean>> getVocabulariesObject(JsonNode node) {
        return Optional.of(node).filter(JsonNode::isObject).map(JsonNode::asObject).flatMap(JsonParser::getVocabulariesObject);
    }

    static Optional<Map<String, Boolean>> getVocabulariesObject(Map<String, JsonNode> objectNode) {
        return Optional.of(objectNode).map(obj -> (JsonNode)obj.get("$vocabulary")).filter(JsonNode::isObject).map(JsonNode::asObject).map(obj -> obj.entrySet().stream().filter(entry -> ((JsonNode)entry.getValue()).isBoolean()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonNode)entry.getValue()).asBoolean()))).map(Collections::unmodifiableMap);
    }

    private MetaValidationResult validateSchemaOrPostpone(JsonNode node, String metaSchemaUri, String baseUri, Optional<String> providedSchemaId) {
        if (metaSchemaUri == null) {
            return new MetaValidationResult(this.dialect.getSupportedVocabularies(), null);
        }
        if (!baseUri.equals(metaSchemaUri) && providedSchemaId.map(id -> !id.equals(metaSchemaUri)).orElse(true).booleanValue()) {
            Set<String> activeVocabularies = this.metaSchemaValidator.validateSchema(this, metaSchemaUri, providedSchemaId.orElse(baseUri), node);
            return new MetaValidationResult(activeVocabularies, null);
        }
        Map<String, Boolean> vocabularyObject = JsonParser.getVocabulariesObject(node).orElse(this.dialect.getDefaultVocabularyObject());
        Set<String> activeVocabularies = this.metaSchemaValidator.determineActiveVocabularies(vocabularyObject);
        return new MetaValidationResult(activeVocabularies, this.schemaRegistry.createSnapshot());
    }

    private final class MetaValidationResult {
        private final Set<String> activeVocabularies;
        private final SchemaRegistry.State recoveryState;

        private MetaValidationResult(Set<String> activeVocabularies, SchemaRegistry.State recoveryState) {
            this.activeVocabularies = Objects.requireNonNull(activeVocabularies);
            this.recoveryState = recoveryState;
        }

        private void performPostponedSchemaValidation(JsonNode node, String metaSchemaUri, String baseUri, Optional<String> providedSchemaId) {
            if (this.recoveryState == null) {
                return;
            }
            try {
                JsonParser.this.metaSchemaValidator.validateSchema(JsonParser.this, metaSchemaUri, providedSchemaId.orElse(baseUri), node);
            }
            catch (JsonSchemaException e) {
                JsonParser.this.schemaRegistry.restoreSnapshot(this.recoveryState);
                throw e;
            }
        }
    }
}

