/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Set;

class ItemsEvaluator
implements Evaluator {
    private final String schemaRef;

    ItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        Integer prefixItemsSize = ctx.getSiblingAnnotation("prefixItems", Integer.class).orElse(0);
        boolean valid = node.asArray().stream().skip(prefixItemsSize.intValue()).allMatch(element -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)element));
        return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

