/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class AnyOfEvaluator
implements Applicator {
    private final List<String> refs;

    AnyOfEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.refs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getAbsoluteUri).collect(Collectors.toList()));
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        return this.refs.stream().filter(pointer -> ctx.resolveInternalRefAndValidate((String)pointer, node)).count() > 0L;
    }
}

