/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class AdditionalPropertiesEvaluator
implements Evaluator {
    private final String schemaRef;

    AdditionalPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        HashSet props = new HashSet();
        props.addAll(ctx.getSiblingAnnotation("properties", Set.class).orElse(Collections.emptySet()));
        props.addAll(ctx.getSiblingAnnotation("patternProperties", Set.class).orElse(Collections.emptySet()));
        Map<String, JsonNode> filtered = node.asObject().entrySet().stream().filter(e -> !props.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean valid = filtered.values().stream().allMatch(prop -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)prop));
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(filtered.keySet())) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

