/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompositeSchemaResolver;
import dev.harrel.jsonschema.Draft2020EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.providers.JacksonNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ValidatorFactory {
    private static final String DEFAULT_META_SCHEMA = "https://json-schema.org/draft/2020-12/schema";
    private EvaluatorFactory evaluatorFactory = new Draft2020EvaluatorFactory();
    private Supplier<JsonNodeFactory> jsonNodeFactory = JacksonNode.Factory::new;
    private SchemaResolver schemaResolver = new DefaultMetaSchemaResolver();
    private String defaultMetaSchemaUri = "https://json-schema.org/draft/2020-12/schema";

    public Validator createValidator() {
        return new Validator(this.evaluatorFactory, this.jsonNodeFactory.get(), this.schemaResolver, this.defaultMetaSchemaUri);
    }

    public ValidatorFactory withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        return this;
    }

    public ValidatorFactory withJsonNodeFactory(JsonNodeFactory jsonNodeFactory) {
        Objects.requireNonNull(jsonNodeFactory);
        this.jsonNodeFactory = () -> jsonNodeFactory;
        return this;
    }

    public ValidatorFactory withSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = CompositeSchemaResolver.of(Objects.requireNonNull(schemaResolver), new DefaultMetaSchemaResolver());
        return this;
    }

    public ValidatorFactory withDefaultMetaSchemaUri(String defaultMetaSchemaUri) {
        this.defaultMetaSchemaUri = defaultMetaSchemaUri;
        return this;
    }

    public Validator.Result validate(String rawSchema, String rawInstance) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(Object schemaProviderNode, String rawInstance) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(JsonNode schemaNode, String rawInstance) {
        return this.validate(schemaNode, this.jsonNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(String rawSchema, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(Object schemaProviderNode, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(JsonNode schemaNode, Object instanceProviderNode) {
        return this.validate(schemaNode, this.jsonNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(String rawSchema, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.get().create(rawSchema), instanceNode);
    }

    public Validator.Result validate(Object schemaProviderNode, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.get().wrap(schemaProviderNode), instanceNode);
    }

    public Validator.Result validate(JsonNode schemaNode, JsonNode instanceNode) {
        Validator validator = this.createValidator();
        URI uri = validator.registerSchema(schemaNode);
        return validator.validate(uri, instanceNode);
    }

    static class DefaultMetaSchemaResolver
    implements SchemaResolver {
        private String rawSchema;

        DefaultMetaSchemaResolver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SchemaResolver.Result resolve(String uri) {
            if (!ValidatorFactory.DEFAULT_META_SCHEMA.equals(uri)) return SchemaResolver.Result.empty();
            if (this.rawSchema != null) {
                return SchemaResolver.Result.fromString(this.rawSchema);
            }
            try (InputStream is = this.getClass().getResourceAsStream("/draft2020-12.json");){
                if (is == null) return SchemaResolver.Result.empty();
                this.rawSchema = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining());
                SchemaResolver.Result result = SchemaResolver.Result.fromString(this.rawSchema);
                return result;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

