/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface SchemaResolver {
    public Result resolve(String var1);

    public static final class Result {
        private final Function<JsonNodeFactory, JsonNode> toNodeFunction;

        private Result(Function<JsonNodeFactory, JsonNode> toNodeFunction) {
            this.toNodeFunction = toNodeFunction;
        }

        public static Result empty() {
            return new Result(null);
        }

        public static Result fromString(String rawSchema) {
            Objects.requireNonNull(rawSchema);
            return new Result(factory -> factory.create(rawSchema));
        }

        public static Result fromProviderNode(Object schemaProviderNode) {
            Objects.requireNonNull(schemaProviderNode);
            return new Result(factory -> factory.wrap(schemaProviderNode));
        }

        public static Result fromJsonNode(JsonNode schemaNode) {
            Objects.requireNonNull(schemaNode);
            return new Result(factory -> schemaNode);
        }

        boolean isEmpty() {
            return this.toNodeFunction == null;
        }

        Optional<JsonNode> toJsonNode(JsonNodeFactory factory) {
            return this.isEmpty() ? Optional.empty() : Optional.of(this.toNodeFunction.apply(factory));
        }
    }
}

