/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collection;
import java.util.List;

class MinContainsEvaluator
implements Evaluator {
    private final int min;

    MinContainsEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.min = node.asInteger().intValueExact();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        int containsCount = ctx.getSiblingAnnotation("contains", List.class).map(Collection::size).orElse(Integer.MAX_VALUE);
        if (containsCount >= this.min) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("Array contains less than %d matching items", this.min));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

