/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationItem;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class EvaluationContext {
    private final JsonNodeFactory jsonNodeFactory;
    private final JsonParser jsonParser;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;
    private final Deque<URI> dynamicScope = new LinkedList<URI>();
    private final Deque<RefStackItem> refStack = new LinkedList<RefStackItem>();
    private final Deque<String> evaluationStack = new LinkedList<String>();
    private final List<EvaluationItem> evaluationItems = new ArrayList<EvaluationItem>();
    private final List<EvaluationItem> validationItems = new ArrayList<EvaluationItem>();

    EvaluationContext(JsonNodeFactory jsonNodeFactory, JsonParser jsonParser, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.jsonParser = Objects.requireNonNull(jsonParser);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    public List<EvaluationItem> getEvaluationItems() {
        return Collections.unmodifiableList(this.evaluationItems);
    }

    public boolean resolveRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveSchema(schemaRef).map(schema -> this.validateAgainstRefSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(schemaRef));
    }

    public boolean resolveDynamicRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveDynamicSchema(schemaRef).map(schema -> this.validateAgainstRefSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(schemaRef));
    }

    public boolean resolveInternalRefAndValidate(String schemaRef, JsonNode node) {
        return Optional.ofNullable(this.schemaRegistry.get(schemaRef)).map(schema -> this.validateAgainstSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(schemaRef));
    }

    List<EvaluationItem> getValidationItems() {
        return Collections.unmodifiableList(this.validationItems);
    }

    <T> Optional<T> getSiblingAnnotation(String sibling, Class<T> annotationType) {
        String parentPath = UriUtil.getJsonPointerParent(this.evaluationStack.element());
        return this.evaluationItems.stream().filter(item -> sibling.equals(item.getKeyword())).filter(item -> parentPath.equals(UriUtil.getJsonPointerParent(item.getEvaluationPath()))).map(EvaluationItem::getAnnotation).filter(annotationType::isInstance).map(annotationType::cast).findAny();
    }

    boolean validateAgainstSchema(Schema schema, JsonNode node) {
        boolean outOfDynamicScope = this.isOutOfDynamicScope(schema.getParentUri());
        if (outOfDynamicScope) {
            this.dynamicScope.push(schema.getParentUri());
        }
        int annotationsBefore = this.getEvaluationItems().size();
        boolean valid = true;
        for (EvaluatorWrapper evaluator : schema.getEvaluators()) {
            String evaluationPath = this.resolveEvaluationPath(evaluator);
            this.evaluationStack.push(evaluationPath);
            Evaluator.Result result = evaluator.evaluate(this, node);
            EvaluationItem evaluationItem = new EvaluationItem(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.isValid(), result.getAnnotation(), result.getError());
            this.evaluationItems.add(evaluationItem);
            this.validationItems.add(evaluationItem);
            valid = valid && result.isValid();
            this.evaluationStack.pop();
        }
        if (!valid) {
            this.evaluationItems.subList(annotationsBefore, this.evaluationItems.size()).clear();
        }
        if (outOfDynamicScope) {
            this.dynamicScope.pop();
        }
        return valid;
    }

    private boolean validateAgainstRefSchema(Schema schema, JsonNode node) {
        this.refStack.push(new RefStackItem(UriUtil.getJsonPointer(schema.getSchemaLocation()), this.evaluationStack.peek()));
        boolean valid = this.validateAgainstSchema(schema, node);
        this.refStack.pop();
        return valid;
    }

    private Optional<Schema> resolveSchema(String ref) {
        String resolvedUri = UriUtil.resolveUri(this.dynamicScope.element(), ref);
        return OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(resolvedUri)), () -> Optional.ofNullable(this.schemaRegistry.getDynamic(resolvedUri)), () -> this.resolveExternalSchema(resolvedUri));
    }

    private Optional<Schema> resolveDynamicSchema(String ref) {
        String resolvedUri = UriUtil.resolveUri(this.dynamicScope.element(), ref);
        if (this.schemaRegistry.get(resolvedUri) != null) {
            return Optional.of(this.schemaRegistry.get(resolvedUri));
        }
        Optional<String> anchor = UriUtil.getAnchor(ref);
        if (anchor.isPresent()) {
            Iterator<URI> it = this.dynamicScope.descendingIterator();
            while (it.hasNext()) {
                Schema schema = this.schemaRegistry.getDynamic(it.next().toString() + "#" + anchor.get());
                if (schema == null) continue;
                return Optional.of(schema);
            }
        }
        return Optional.empty();
    }

    private boolean isOutOfDynamicScope(URI uri) {
        return this.dynamicScope.isEmpty() || !uri.equals(this.dynamicScope.peek());
    }

    private String resolveEvaluationPath(EvaluatorWrapper evaluator) {
        if (this.refStack.isEmpty()) {
            return evaluator.getKeywordPath();
        }
        RefStackItem refItem = this.refStack.peek();
        String currentPath = evaluator.getKeywordPath();
        if (!currentPath.startsWith(refItem.schemaLocation)) {
            throw new IllegalStateException("Unexpected evaluation path resolution error");
        }
        String evaluationPathPart = currentPath.substring(refItem.schemaLocation.length());
        return refItem.evaluationPath + evaluationPathPart;
    }

    private Optional<Schema> resolveExternalSchema(String uri) {
        String baseUri = UriUtil.getUriWithoutFragment(uri);
        if (this.schemaRegistry.get(baseUri) != null) {
            return Optional.empty();
        }
        return this.schemaResolver.resolve(baseUri).toJsonNode(this.jsonNodeFactory).flatMap(node -> {
            this.jsonParser.parseRootSchema(URI.create(baseUri), (JsonNode)node);
            return this.resolveSchema(uri);
        });
    }

    private static class RefStackItem {
        private final String schemaLocation;
        private final String evaluationPath;

        public RefStackItem(String schemaLocation, String evaluationPath) {
            this.schemaLocation = schemaLocation;
            this.evaluationPath = evaluationPath;
        }
    }
}

