/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class EnumEvaluator
implements Evaluator {
    private final List<JsonNode> enumNodes;

    EnumEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.enumNodes = Collections.unmodifiableList(node.asArray());
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (this.enumNodes.stream().anyMatch(node::isEqualTo)) {
            return Evaluator.Result.success();
        }
        List printList = this.enumNodes.stream().map(JsonNode::toPrintableString).collect(Collectors.toList());
        return Evaluator.Result.failure(String.format("Expected any of [%s]", printList));
    }
}

