/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.SchemaResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CompositeSchemaResolver
implements SchemaResolver {
    private final List<SchemaResolver> resolvers;

    private CompositeSchemaResolver(List<SchemaResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public static CompositeSchemaResolver of(SchemaResolver ... resolvers) {
        return new CompositeSchemaResolver(Collections.unmodifiableList(Arrays.asList(resolvers)));
    }

    @Override
    public SchemaResolver.Result resolve(String uri) {
        return this.resolvers.stream().map(resolver -> resolver.resolve(uri)).filter(result -> !result.isEmpty()).findFirst().orElse(SchemaResolver.Result.empty());
    }
}

