/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class TypeEvaluator
implements Evaluator {
    private final Set<SimpleType> types;

    TypeEvaluator(JsonNode node) {
        if (!node.isString() && !node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.types = node.isString() ? Collections.singleton(SimpleType.fromName(node.asString())) : node.asArray().stream().map(JsonNode::asString).map(SimpleType::fromName).collect(Collectors.toSet());
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        SimpleType nodeType = node.getNodeType();
        if (this.types.contains((Object)nodeType) || nodeType == SimpleType.INTEGER && this.types.contains((Object)SimpleType.NUMBER)) {
            return Evaluator.Result.success();
        }
        List typeNames = Collections.unmodifiableList(this.types.stream().map(SimpleType::getName).collect(Collectors.toList()));
        return Evaluator.Result.failure(String.format("Value is [%s] but should be %s", nodeType.getName(), typeNames));
    }
}

