/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaRegistry;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public final class SchemaParsingContext {
    private final URI baseUri;
    private final URI parentUri;
    private final SchemaRegistry schemaRegistry;
    private final Map<String, JsonNode> currentSchemaObject;

    private SchemaParsingContext(URI baseUri, URI parentUri, SchemaRegistry schemaRegistry, Map<String, JsonNode> currentSchemaObject) {
        this.baseUri = baseUri;
        this.parentUri = parentUri;
        this.schemaRegistry = schemaRegistry;
        this.currentSchemaObject = currentSchemaObject;
    }

    SchemaParsingContext(SchemaRegistry schemaRegistry, String baseUri) {
        this(URI.create(baseUri), URI.create(baseUri), schemaRegistry, Collections.emptyMap());
    }

    SchemaParsingContext withParentUri(URI parentUri) {
        return new SchemaParsingContext(this.baseUri, parentUri, this.schemaRegistry, this.currentSchemaObject);
    }

    SchemaParsingContext withCurrentSchemaContext(Map<String, JsonNode> currentSchemaObject) {
        return new SchemaParsingContext(this.baseUri, this.parentUri, this.schemaRegistry, Collections.unmodifiableMap(currentSchemaObject));
    }

    public URI getParentUri() {
        return this.parentUri;
    }

    public String getAbsoluteUri(JsonNode node) {
        return this.getAbsoluteUri(node.getJsonPointer());
    }

    public String getAbsoluteUri(String jsonPointer) {
        if (jsonPointer.isEmpty()) {
            return this.baseUri + "#";
        }
        if (jsonPointer.startsWith("#")) {
            return this.baseUri + jsonPointer;
        }
        return this.baseUri + "#" + jsonPointer;
    }

    public Map<String, JsonNode> getCurrentSchemaObject() {
        return Collections.unmodifiableMap(this.currentSchemaObject);
    }
}

