/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

final class Schema {
    private static final Evaluator TRUE_EVALUATOR = (ctx, node) -> Evaluator.Result.success();
    private static final Evaluator FALSE_EVALUATOR = (ctx, node) -> Evaluator.Result.failure("False schema always fails.");
    private final URI parentUri;
    private final String schemaLocation;
    private final List<EvaluatorWrapper> evaluators;

    Schema(URI parentUri, String schemaLocation, List<EvaluatorWrapper> evaluators) {
        this.parentUri = parentUri;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        Objects.requireNonNull(evaluators);
        ArrayList<EvaluatorWrapper> unsortedEvaluators = new ArrayList<EvaluatorWrapper>(evaluators);
        unsortedEvaluators.sort(Comparator.comparingInt(Evaluator::getOrder));
        this.evaluators = Collections.unmodifiableList(unsortedEvaluators);
    }

    static Evaluator getBooleanEvaluator(boolean val) {
        return val ? TRUE_EVALUATOR : FALSE_EVALUATOR;
    }

    URI getParentUri() {
        return this.parentUri;
    }

    String getSchemaLocation() {
        return this.schemaLocation;
    }

    List<EvaluatorWrapper> getEvaluators() {
        return this.evaluators;
    }
}

