/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaNotFoundException;

class RefEvaluator
implements Evaluator {
    private final String ref;

    RefEvaluator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.ref = node.asString();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        try {
            return ctx.resolveRefAndValidate(this.ref, node) ? Evaluator.Result.success() : Evaluator.Result.failure();
        }
        catch (SchemaNotFoundException e) {
            return Evaluator.Result.failure(String.format("Resolution of $ref [%s] failed", this.ref));
        }
    }
}

