/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PrefixItemsEvaluator
implements Evaluator {
    private final List<String> prefixRefs;

    PrefixItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.prefixRefs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getAbsoluteUri).collect(Collectors.toList()));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> elements = node.asArray();
        boolean valid = IntStream.range(0, elements.size()).limit(this.prefixRefs.size()).boxed().allMatch(idx -> ctx.resolveInternalRefAndValidate(this.prefixRefs.get((int)idx), (JsonNode)elements.get((int)idx)));
        return valid ? Evaluator.Result.success(this.prefixRefs.size()) : Evaluator.Result.failure();
    }
}

