/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.InvalidSchemaException;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaResolvingException;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Validator;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

final class MetaSchemaValidator {
    private static final String RESOLVING_ERROR_MSG = "Cannot resolve meta-schema [%s]";
    private final JsonNodeFactory jsonNodeFactory;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;

    MetaSchemaValidator(JsonNodeFactory jsonNodeFactory, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    void validateMetaSchema(JsonParser jsonParser, String metaSchemaUri, String schemaUri, JsonNode node) {
        if (metaSchemaUri == null || metaSchemaUri.equals(schemaUri)) {
            return;
        }
        EvaluationContext ctx = new EvaluationContext(this.jsonNodeFactory, jsonParser, this.schemaRegistry, this.schemaResolver);
        Schema schema = this.resolveMetaSchema(jsonParser, metaSchemaUri);
        if (!ctx.validateAgainstSchema(schema, node)) {
            throw new InvalidSchemaException(String.format("Schema [%s] failed to validate against meta-schema [%s]", schemaUri, metaSchemaUri), Validator.Result.fromEvaluationContext(false, ctx).getErrors());
        }
    }

    private Schema resolveMetaSchema(JsonParser jsonParser, String uri) {
        return OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(uri)), () -> Optional.ofNullable(this.schemaRegistry.getDynamic(uri))).orElseGet(() -> this.resolveExternalSchema(jsonParser, uri));
    }

    private Schema resolveExternalSchema(JsonParser jsonParser, String uri) {
        String baseUri = UriUtil.getUriWithoutFragment(uri);
        if (this.schemaRegistry.get(baseUri) != null) {
            throw new MetaSchemaResolvingException(String.format(RESOLVING_ERROR_MSG, uri));
        }
        return this.schemaResolver.resolve(baseUri).toJsonNode(this.jsonNodeFactory).map(node -> {
            try {
                jsonParser.parseRootSchema(URI.create(baseUri), (JsonNode)node);
                return this.resolveMetaSchema(jsonParser, uri);
            }
            catch (Exception e) {
                throw new MetaSchemaResolvingException(String.format("Parsing meta-schema [%s] failed", uri), e);
            }
        }).orElseThrow(() -> new MetaSchemaResolvingException(String.format(RESOLVING_ERROR_MSG, uri)));
    }
}

