/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Map;
import java.util.stream.Collectors;

class DependentSchemasEvaluator
implements Applicator {
    private final Map<String, String> dependentSchemas;

    DependentSchemasEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.dependentSchemas = node.asObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ctx.getAbsoluteUri((JsonNode)e.getValue())));
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        return node.asObject().keySet().stream().filter(this.dependentSchemas::containsKey).map(this.dependentSchemas::get).allMatch(ref -> ctx.resolveInternalRefAndValidate((String)ref, node));
    }
}

