/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JacksonNode
implements JsonNode {
    private static final Map<JsonNodeType, SimpleType> TYPE_MAP = Map.of(JsonNodeType.NULL, SimpleType.NULL, JsonNodeType.BOOLEAN, SimpleType.BOOLEAN, JsonNodeType.STRING, SimpleType.STRING, JsonNodeType.NUMBER, SimpleType.NUMBER, JsonNodeType.ARRAY, SimpleType.ARRAY, JsonNodeType.OBJECT, SimpleType.OBJECT);
    private final com.fasterxml.jackson.databind.JsonNode node;
    private final String jsonPointer;

    private JacksonNode(com.fasterxml.jackson.databind.JsonNode node, String jsonPointer) {
        this.node = node;
        this.jsonPointer = jsonPointer;
    }

    public JacksonNode(com.fasterxml.jackson.databind.JsonNode node) {
        this(node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        SimpleType type = TYPE_MAP.get(this.node.getNodeType());
        if (this.node.canConvertToExactIntegral()) {
            return SimpleType.INTEGER;
        }
        return type;
    }

    @Override
    public boolean asBoolean() {
        return this.node.asBoolean();
    }

    @Override
    public String asString() {
        return this.node.asText();
    }

    @Override
    public BigInteger asInteger() {
        return this.node.bigIntegerValue();
    }

    @Override
    public BigDecimal asNumber() {
        return this.node.decimalValue();
    }

    @Override
    public List<JsonNode> asArray() {
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>();
        Iterator iterator = this.node.elements();
        while (iterator.hasNext()) {
            elements.add(new JacksonNode((com.fasterxml.jackson.databind.JsonNode)iterator.next(), this.jsonPointer + "/" + elements.size()));
        }
        return elements;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        Iterator iterator = this.node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            map.put((String)entry.getKey(), new JacksonNode((com.fasterxml.jackson.databind.JsonNode)entry.getValue(), this.jsonPointer + "/" + (String)entry.getKey()));
        }
        return map;
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final ObjectMapper mapper;

        public Factory() {
            this(new ObjectMapper());
        }

        public Factory(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public JacksonNode wrap(Object node) {
            if (node instanceof com.fasterxml.jackson.databind.JsonNode) {
                com.fasterxml.jackson.databind.JsonNode vendorNode = (com.fasterxml.jackson.databind.JsonNode)node;
                return new JacksonNode(vendorNode);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of com.fasterxml.jackson.databind.JsonNode");
        }

        @Override
        public JacksonNode create(String rawJson) {
            try {
                return new JacksonNode(this.mapper.readTree(rawJson));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

