/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompositeSchemaResolver;
import dev.harrel.jsonschema.CoreEvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.providers.JacksonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public final class ValidatorFactory {
    private static final String DEFAULT_META_SCHEMA = "https://json-schema.org/draft/2020-12/schema";
    private EvaluatorFactory evaluatorFactory = new CoreEvaluatorFactory();
    private JsonNodeFactory jsonNodeFactory = new JacksonNode.Factory();
    private SchemaResolver schemaResolver = new DefaultMetaSchemaResolver();
    private String defaultMetaSchemaUri = "https://json-schema.org/draft/2020-12/schema";

    public Validator createValidator() {
        return new Validator(this.evaluatorFactory, this.jsonNodeFactory, this.schemaResolver, this.defaultMetaSchemaUri);
    }

    public ValidatorFactory withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        return this;
    }

    public ValidatorFactory withJsonNodeFactory(JsonNodeFactory jsonNodeFactory) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        return this;
    }

    public ValidatorFactory withSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = CompositeSchemaResolver.of(Objects.requireNonNull(schemaResolver), new DefaultMetaSchemaResolver());
        return this;
    }

    public ValidatorFactory withDefaultMetaSchemaUri(String defaultMetaSchemaUri) {
        this.defaultMetaSchemaUri = defaultMetaSchemaUri;
        return this;
    }

    public ValidationResult validate(String rawSchema, String rawInstance) {
        return this.validate(this.jsonNodeFactory.create(rawSchema), this.jsonNodeFactory.create(rawInstance));
    }

    public ValidationResult validate(Object schemaProviderNode, String rawInstance) {
        return this.validate(this.jsonNodeFactory.wrap(schemaProviderNode), this.jsonNodeFactory.create(rawInstance));
    }

    public ValidationResult validate(JsonNode schemaNode, String rawInstance) {
        return this.validate(schemaNode, this.jsonNodeFactory.create(rawInstance));
    }

    public ValidationResult validate(String rawSchema, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.create(rawSchema), this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public ValidationResult validate(Object schemaProviderNode, Object instanceProviderNode) {
        return this.validate(this.jsonNodeFactory.wrap(schemaProviderNode), this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public ValidationResult validate(JsonNode schemaNode, Object instanceProviderNode) {
        return this.validate(schemaNode, this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public ValidationResult validate(String rawSchema, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.create(rawSchema), instanceNode);
    }

    public ValidationResult validate(Object schemaProviderNode, JsonNode instanceNode) {
        return this.validate(this.jsonNodeFactory.wrap(schemaProviderNode), instanceNode);
    }

    public ValidationResult validate(JsonNode schemaNode, JsonNode instanceNode) {
        Validator validator = this.createValidator();
        URI uri = validator.registerSchema(schemaNode);
        return validator.validate(uri, instanceNode);
    }

    static class DefaultMetaSchemaResolver
    implements SchemaResolver {
        DefaultMetaSchemaResolver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<String> resolve(String uri) {
            if (!ValidatorFactory.DEFAULT_META_SCHEMA.equals(uri)) return Optional.empty();
            try (InputStream is = this.getClass().getResourceAsStream("/draft2020-12.json");){
                if (is == null) return Optional.empty();
                Optional<String> optional = Optional.of(new String(is.readAllBytes(), StandardCharsets.UTF_8));
                return optional;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

