/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.ValidationResult;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;

public final class Validator {
    private final JsonNodeFactory jsonNodeFactory;
    private final SchemaResolver schemaResolver;
    private final SchemaRegistry schemaRegistry;
    private final JsonParser jsonParser;

    Validator(EvaluatorFactory evaluatorFactory, JsonNodeFactory jsonNodeFactory, SchemaResolver schemaResolver, String defaultMetaSchemaUri) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.schemaRegistry = new SchemaRegistry();
        MetaSchemaValidator metaSchemaValidator = new MetaSchemaValidator(this.schemaRegistry, this.schemaResolver);
        this.jsonParser = new JsonParser(defaultMetaSchemaUri, this.jsonNodeFactory, evaluatorFactory, this.schemaRegistry, metaSchemaValidator);
    }

    public URI registerSchema(String rawSchema) {
        return this.registerSchema(this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(Object schemaProviderNode) {
        return this.registerSchema(this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(URI.create(UUID.randomUUID().toString()), schemaNode);
    }

    public URI registerSchema(URI uri, String rawSchema) {
        return this.registerSchema(uri, this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(URI uri, Object schemaProviderNode) {
        return this.registerSchema(uri, this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(URI uri, JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(uri, schemaNode);
    }

    public ValidationResult validate(URI schemaUri, String rawInstance) {
        return this.validate(schemaUri, this.jsonNodeFactory.create(rawInstance));
    }

    public ValidationResult validate(URI schemaUri, Object instanceProviderNode) {
        return this.validate(schemaUri, this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public ValidationResult validate(URI schemaUri, JsonNode instanceNode) {
        Schema schema = this.getRootSchema(schemaUri.toString());
        EvaluationContext ctx = this.createNewEvaluationContext();
        boolean valid = schema.validate(ctx, instanceNode);
        return ValidationResult.fromEvaluationContext(valid, ctx);
    }

    private Schema getRootSchema(String uri) {
        Schema schema = this.schemaRegistry.get(uri);
        if (schema == null) {
            throw new IllegalArgumentException("Couldn't find schema with uri [%s]".formatted(uri));
        }
        return schema;
    }

    private EvaluationContext createNewEvaluationContext() {
        return new EvaluationContext(this.jsonParser, this.schemaRegistry, this.schemaResolver);
    }
}

