/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.List;

class UnevaluatedItemsEvaluator
implements Applicator {
    private final String schemaRef;
    private final String parentPath;

    UnevaluatedItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        String schemaPointer = node.getJsonPointer();
        this.schemaRef = ctx.getAbsoluteUri(schemaPointer);
        this.parentPath = schemaPointer.substring(0, schemaPointer.lastIndexOf(47));
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return true;
        }
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        List<Annotation> annotations = ctx.getAnnotations().stream().filter(a -> a.header().evaluationPath().startsWith(this.parentPath)).toList();
        return node.asArray().stream().filter(arrayNode -> annotations.stream().noneMatch(a -> a.header().instanceLocation().startsWith(arrayNode.getJsonPointer()))).allMatch(arrayNode -> schema.validate(ctx, (JsonNode)arrayNode));
    }

    @Override
    public int getOrder() {
        return 20;
    }
}

