/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationHeader;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class Schema {
    private static final Evaluator TRUE_EVALUATOR = (ctx, node) -> EvaluationResult.success();
    private static final Evaluator FALSE_EVALUATOR = (ctx, node) -> EvaluationResult.failure("False schema always fails.");
    private final URI parentUri;
    private final String schemaLocation;
    private final List<EvaluatorWrapper> evaluators;

    Schema(URI parentUri, String schemaLocation, List<EvaluatorWrapper> evaluators) {
        this.parentUri = parentUri;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        Objects.requireNonNull(evaluators);
        ArrayList<EvaluatorWrapper> unsortedEvaluators = new ArrayList<EvaluatorWrapper>(evaluators);
        Collections.sort(unsortedEvaluators);
        this.evaluators = Collections.unmodifiableList(unsortedEvaluators);
    }

    static Evaluator getBooleanEvaluator(boolean val) {
        return val ? TRUE_EVALUATOR : FALSE_EVALUATOR;
    }

    boolean validate(EvaluationContext ctx, JsonNode node) {
        boolean outOfDynamicScope = ctx.isOutOfDynamicScope(this.parentUri);
        if (outOfDynamicScope) {
            ctx.pushDynamicScope(this.parentUri);
        }
        int annotationsBefore = ctx.getAnnotations().size();
        boolean valid = true;
        for (EvaluatorWrapper evaluator : this.evaluators) {
            EvaluationResult result = evaluator.evaluate(ctx, node);
            Annotation annotation = new Annotation(new AnnotationHeader(evaluator.getKeywordPath(), this.schemaLocation, node.getJsonPointer()), evaluator.getKeyword(), result.getErrorMessage(), result.isValid());
            ctx.addValidationAnnotation(annotation);
            ctx.addAnnotation(annotation);
            valid = valid && result.isValid();
        }
        if (!valid) {
            ctx.truncateAnnotationsToSize(annotationsBefore);
        }
        if (outOfDynamicScope) {
            ctx.popDynamicContext();
        }
        return valid;
    }
}

