/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RequiredEvaluator
implements Evaluator {
    private final List<String> requiredProperties;

    RequiredEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.requiredProperties = node.asArray().stream().map(JsonNode::asString).toList();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return EvaluationResult.success();
        }
        Set<String> keys = node.asObject().keySet();
        if (keys.containsAll(this.requiredProperties)) {
            return EvaluationResult.success();
        }
        HashSet<String> unsatisfied = new HashSet<String>(this.requiredProperties);
        unsatisfied.removeAll(keys);
        return EvaluationResult.failure("Object does not have some of the required properties [%s]".formatted(unsatisfied));
    }
}

