/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import java.util.Optional;

class RefEvaluator
implements Evaluator {
    private final String ref;

    RefEvaluator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.ref = node.asString();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        Optional<Schema> schema = ctx.resolveSchema(this.ref);
        if (schema.isEmpty()) {
            return EvaluationResult.failure("Resolution of $ref [%s] failed".formatted(this.ref));
        }
        return schema.get().validate(ctx, node) ? EvaluationResult.success() : EvaluationResult.failure();
    }
}

