/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class PropertiesEvaluator
implements Applicator {
    private final Map<String, String> schemaRefs;

    PropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> uris = new HashMap<String, String>();
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            uris.put(entry.getKey(), ctx.getAbsoluteUri(entry.getValue()));
        }
        this.schemaRefs = Collections.unmodifiableMap(uris);
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        return node.asObject().entrySet().stream().filter(e -> this.schemaRefs.containsKey(e.getKey())).map(e -> Map.entry(this.schemaRefs.get(e.getKey()), (JsonNode)e.getValue())).allMatch(e -> ctx.resolveRequiredSchema((String)e.getKey()).validate(ctx, (JsonNode)e.getValue()));
    }
}

