/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.List;
import java.util.stream.IntStream;

class PrefixItemsEvaluator
implements Applicator {
    private final List<String> prefixRefs;

    PrefixItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.prefixRefs = node.asArray().stream().map(ctx::getAbsoluteUri).toList();
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return true;
        }
        List<JsonNode> elements = node.asArray();
        return IntStream.range(0, elements.size()).limit(this.prefixRefs.size()).boxed().allMatch(idx -> ctx.resolveRequiredSchema(this.prefixRefs.get((int)idx)).validate(ctx, (JsonNode)elements.get((int)idx)));
    }
}

