/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class PatternPropertiesEvaluator
implements Applicator {
    private final Map<Pattern, String> schemasByPatterns;

    PatternPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.schemasByPatterns = node.asObject().entrySet().stream().collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey()), e -> ctx.getAbsoluteUri((JsonNode)e.getValue())));
    }

    @Override
    public boolean apply(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        boolean valid = true;
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            List<Schema> schemas = this.schemasByPatterns.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher((CharSequence)entry.getKey()).find()).map(Map.Entry::getValue).map(ctx::resolveRequiredSchema).toList();
            valid = schemas.stream().allMatch(schema -> schema.validate(ctx, (JsonNode)entry.getValue())) && valid;
        }
        return valid;
    }
}

