/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.regex.Pattern;

class PatternEvaluator
implements Evaluator {
    private final Pattern pattern;

    PatternEvaluator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.pattern = Pattern.compile(node.asString());
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return EvaluationResult.success();
        }
        if (this.pattern.matcher(node.asString()).find()) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("\"%s\" does not match regular expression [%s]".formatted(node.asString(), this.pattern.toString()));
    }
}

