/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.math.BigDecimal;

class MultipleOfEvaluator
implements Evaluator {
    private final BigDecimal factor;

    MultipleOfEvaluator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.factor = node.asNumber();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return EvaluationResult.success();
        }
        if (node.asNumber().remainder(this.factor).doubleValue() == 0.0) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("%s is not multiple of %s".formatted(node.asNumber(), this.factor));
    }
}

