/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;

class MinLengthEvaluator
implements Evaluator {
    private final int minLength;

    MinLengthEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.minLength = node.asInteger().intValueExact();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return EvaluationResult.success();
        }
        String string = node.asString();
        if (string.codePointCount(0, string.length()) >= this.minLength) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("\"%s\" is shorter than %d characters".formatted(string, this.minLength));
    }
}

