/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Optional;

class MinContainsEvaluator
implements Evaluator {
    private final String containsPath;
    private final int min;

    MinContainsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.containsPath = Optional.ofNullable(ctx.getCurrentSchemaObject().get("contains")).map(ctx::getAbsoluteUri).orElse(null);
        this.min = node.asInteger().intValueExact();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray() || this.containsPath == null) {
            return EvaluationResult.success();
        }
        long count = ctx.getAnnotations().stream().filter(a -> a.header().schemaLocation().equals(this.containsPath)).count();
        if (count >= (long)this.min) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("Array contains less than %d matching items".formatted(this.min));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

