/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.InvalidSchemaException;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaResolvingException;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.util.Objects;
import java.util.Optional;

final class MetaSchemaValidator {
    private static final String RESOLVING_ERROR_MSG = "Cannot resolve meta-schema [%s]";
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;

    MetaSchemaValidator(SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    void validateMetaSchema(JsonParser jsonParser, String metaSchemaUri, String schemaUri, JsonNode node) {
        EvaluationContext newCtx;
        if (metaSchemaUri == null || metaSchemaUri.equals(schemaUri)) {
            return;
        }
        Schema schema = this.resolveMetaSchema(jsonParser, metaSchemaUri).orElseThrow(() -> new MetaSchemaResolvingException(RESOLVING_ERROR_MSG.formatted(metaSchemaUri)));
        if (!schema.validate(newCtx = new EvaluationContext(jsonParser, this.schemaRegistry, this.schemaResolver), node)) {
            throw new InvalidSchemaException("Schema [%s] failed to validate against meta-schema [%s]".formatted(schemaUri, metaSchemaUri));
        }
    }

    private Optional<Schema> resolveMetaSchema(JsonParser jsonParser, String uri) {
        return Optional.ofNullable(this.schemaRegistry.get(uri)).or(() -> Optional.ofNullable(this.schemaRegistry.getDynamic(uri))).or(() -> this.resolveExternalSchema(jsonParser, uri));
    }

    private Optional<Schema> resolveExternalSchema(JsonParser jsonParser, String uri) {
        String baseUri = UriUtil.getUriWithoutFragment(uri);
        if (this.schemaRegistry.get(baseUri) != null) {
            throw new MetaSchemaResolvingException(RESOLVING_ERROR_MSG.formatted(uri));
        }
        String rawJson = this.schemaResolver.resolve(baseUri).orElseThrow(() -> new MetaSchemaResolvingException(RESOLVING_ERROR_MSG.formatted(uri)));
        try {
            jsonParser.parseRootSchema(baseUri, rawJson);
            return this.resolveMetaSchema(jsonParser, uri);
        }
        catch (Exception e) {
            throw new MetaSchemaResolvingException("Parsing meta-schema [%s] failed".formatted(uri), e);
        }
    }
}

