/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.math.BigDecimal;

class MaximumEvaluator
implements Evaluator {
    private final BigDecimal max;

    MaximumEvaluator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asNumber();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return EvaluationResult.success();
        }
        if (node.asNumber().compareTo(this.max) <= 0) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("%s is greater than %s".formatted(node.asNumber(), this.max));
    }
}

