/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;

class MaxPropertiesEvaluator
implements Evaluator {
    private final int max;

    MaxPropertiesEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asInteger().intValueExact();
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return EvaluationResult.success();
        }
        if (node.asObject().size() <= this.max) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("Object has more than %d properties".formatted(this.max));
    }
}

