/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.InvalidSchemaException;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SchemaRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class JsonParser {
    private final String defaultMetaSchemaUri;
    private final JsonNodeFactory jsonNodeFactory;
    private final EvaluatorFactory evaluatorFactory;
    private final SchemaRegistry schemaRegistry;
    private final MetaSchemaValidator metaSchemaValidator;

    JsonParser(String defaultMetaSchemaUri, JsonNodeFactory jsonNodeFactory, EvaluatorFactory evaluatorFactory, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator) {
        this.defaultMetaSchemaUri = defaultMetaSchemaUri;
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.metaSchemaValidator = Objects.requireNonNull(metaSchemaValidator);
    }

    void parseRootSchema(String baseUri, String rawJson) {
        this.parseRootSchema(URI.create(baseUri), this.jsonNodeFactory.create(rawJson));
    }

    URI parseRootSchema(URI baseUri, JsonNode node) {
        if (node.isBoolean()) {
            this.metaSchemaValidator.validateMetaSchema(this, this.defaultMetaSchemaUri, baseUri.toString(), node);
            SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, baseUri.toString());
            boolean schemaValue = node.asBoolean();
            this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, List.of(new EvaluatorWrapper(String.valueOf(schemaValue), node, Schema.getBooleanEvaluator(schemaValue))));
            return baseUri;
        }
        if (node.isObject()) {
            Map<String, JsonNode> objectMap = node.asObject();
            String metaSchemaUri = Optional.ofNullable(objectMap.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString).orElse(this.defaultMetaSchemaUri);
            JsonNode idNode = objectMap.get("$id");
            if (idNode != null && idNode.isString()) {
                String idString = idNode.asString();
                this.metaSchemaValidator.validateMetaSchema(this, metaSchemaUri, idString, node);
                if (!baseUri.toString().equals(idString)) {
                    SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, idString);
                    List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
                    this.schemaRegistry.registerIdentifiableSchema(ctx, URI.create(idString), node, evaluators);
                }
            } else {
                this.metaSchemaValidator.validateMetaSchema(this, metaSchemaUri, baseUri.toString(), node);
            }
            SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, baseUri.toString());
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, evaluators);
            return Optional.ofNullable(objectMap.get("$id")).filter(JsonNode::isString).map(JsonNode::asString).map(URI::create).orElse(baseUri);
        }
        throw new InvalidSchemaException("Schema [%s] was of invalid type [%s]".formatted(new Object[]{baseUri, node.getNodeType()}));
    }

    private void parseNode(SchemaParsingContext ctx, JsonNode node) {
        if (node.isBoolean()) {
            this.parseBoolean(ctx, node);
        } else if (node.isArray()) {
            this.parseArray(ctx, node);
        } else if (node.isObject()) {
            this.parseObject(ctx, node);
        }
    }

    private void parseBoolean(SchemaParsingContext ctx, JsonNode node) {
        boolean schemaValue = node.asBoolean();
        Evaluator booleanEvaluator = Schema.getBooleanEvaluator(schemaValue);
        this.schemaRegistry.registerSchema(ctx, node, List.of(new EvaluatorWrapper(String.valueOf(schemaValue), node, booleanEvaluator)));
    }

    private void parseArray(SchemaParsingContext ctx, JsonNode node) {
        for (JsonNode element : node.asArray()) {
            this.parseNode(ctx, element);
        }
    }

    private void parseObject(SchemaParsingContext ctx, JsonNode node) {
        Map<String, JsonNode> objectMap = node.asObject();
        Optional<String> metaSchemaUri = Optional.ofNullable(objectMap.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString);
        JsonNode idNode = objectMap.get("$id");
        if (idNode != null && idNode.isString()) {
            String idString = idNode.asString();
            metaSchemaUri.ifPresent(uri -> this.metaSchemaValidator.validateMetaSchema(this, (String)uri, idString, node));
            URI uri2 = ctx.getParentUri().resolve(idString);
            SchemaParsingContext newCtx = ctx.withParentUri(uri2);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(newCtx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerIdentifiableSchema(newCtx, uri2, node, evaluators);
        } else {
            metaSchemaUri.ifPresent(uri -> this.metaSchemaValidator.validateMetaSchema(this, (String)uri, ctx.getAbsoluteUri(node), node));
            this.schemaRegistry.registerSchema(ctx, node, this.parseEvaluators(ctx, objectMap, node.getJsonPointer()));
        }
    }

    private List<EvaluatorWrapper> parseEvaluators(SchemaParsingContext ctx, Map<String, JsonNode> object, String objectPath) {
        SchemaParsingContext newCtx = ctx.withCurrentSchemaContext(object);
        ArrayList<EvaluatorWrapper> evaluators = new ArrayList<EvaluatorWrapper>();
        for (Map.Entry<String, JsonNode> entry : object.entrySet()) {
            this.evaluatorFactory.create(newCtx, entry.getKey(), entry.getValue()).map(evaluator -> new EvaluatorWrapper((String)entry.getKey(), (JsonNode)entry.getValue(), (Evaluator)evaluator)).ifPresent(evaluators::add);
            this.parseNode(newCtx, entry.getValue());
        }
        if (evaluators.isEmpty()) {
            evaluators.add(new EvaluatorWrapper("true", objectPath, Schema.getBooleanEvaluator(true)));
        }
        return evaluators;
    }
}

