/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.SimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public interface JsonNode {
    public String getJsonPointer();

    public SimpleType getNodeType();

    default public boolean isNull() {
        return this.getNodeType() == SimpleType.NULL;
    }

    default public boolean isBoolean() {
        return this.getNodeType() == SimpleType.BOOLEAN;
    }

    default public boolean isString() {
        return this.getNodeType() == SimpleType.STRING;
    }

    default public boolean isInteger() {
        return this.getNodeType() == SimpleType.INTEGER;
    }

    default public boolean isNumber() {
        return this.getNodeType() == SimpleType.NUMBER || this.getNodeType() == SimpleType.INTEGER;
    }

    default public boolean isArray() {
        return this.getNodeType() == SimpleType.ARRAY;
    }

    default public boolean isObject() {
        return this.getNodeType() == SimpleType.OBJECT;
    }

    public boolean asBoolean();

    public String asString();

    public BigInteger asInteger();

    public BigDecimal asNumber();

    public List<JsonNode> asArray();

    public Map<String, JsonNode> asObject();

    default public String toPrintableString() {
        if (this.isObject()) {
            return "specific object";
        }
        if (this.isArray()) {
            return "specific array";
        }
        return this.asString();
    }

    default public boolean isEqualTo(JsonNode other) {
        if (this.isNull() && other.isNull()) {
            return true;
        }
        if (this.isBoolean() && other.isBoolean()) {
            return this.asBoolean() == other.asBoolean();
        }
        if (this.isString() && other.isString()) {
            return this.asString().equals(other.asString());
        }
        if (this.isInteger() && other.isInteger()) {
            return this.asInteger().equals(other.asInteger());
        }
        if (this.isNumber() && other.isNumber()) {
            return this.asNumber().equals(other.asNumber());
        }
        if (this.isArray() && other.isArray()) {
            return JsonNode.compareArrays(this.asArray(), other.asArray());
        }
        if (this.isObject() && other.isObject()) {
            return JsonNode.compareObjects(this.asObject(), other.asObject());
        }
        return false;
    }

    private static boolean compareArrays(List<JsonNode> arr1, List<JsonNode> arr2) {
        if (arr1.size() != arr2.size()) {
            return false;
        }
        for (int i = 0; i < arr1.size(); ++i) {
            if (arr1.get(i).isEqualTo(arr2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareObjects(Map<String, JsonNode> object1, Map<String, JsonNode> object2) {
        if (object1.size() != object2.size()) {
            return false;
        }
        for (Map.Entry<String, JsonNode> entry : object1.entrySet()) {
            JsonNode otherField = object2.get(entry.getKey());
            if (otherField != null && entry.getValue().isEqualTo(otherField)) continue;
            return false;
        }
        return true;
    }
}

