/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collections;
import java.util.List;

class EnumEvaluator
implements Evaluator {
    private final List<JsonNode> enumNodes;

    EnumEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.enumNodes = Collections.unmodifiableList(node.asArray());
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (this.enumNodes.stream().anyMatch(node::isEqualTo)) {
            return EvaluationResult.success();
        }
        return EvaluationResult.failure("Expected any of [%s]".formatted(this.enumNodes.stream().map(JsonNode::toPrintableString).toList()));
    }
}

