/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationResult;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class DependentRequiredEvaluator
implements Evaluator {
    private final Map<String, List<String>> requiredProperties;

    DependentRequiredEvaluator(JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.requiredProperties = node.asObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toStringList((JsonNode)e.getValue())));
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return EvaluationResult.success();
        }
        Set<String> objectKeys = node.asObject().keySet();
        Set requiredSet = objectKeys.stream().filter(this.requiredProperties::containsKey).map(this.requiredProperties::get).flatMap(Collection::stream).collect(Collectors.toSet());
        if (objectKeys.containsAll(requiredSet)) {
            return EvaluationResult.success();
        }
        requiredSet.removeAll(objectKeys);
        return EvaluationResult.failure("Object does not have some of the required properties [%s]".formatted(requiredSet));
    }

    private List<String> toStringList(JsonNode node) {
        return node.asArray().stream().map(JsonNode::asString).toList();
    }
}

