/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.Objects;

final class ValidatorWrapper
implements Validator {
    private final String keyword;
    private final String keywordPath;
    private final Validator validator;

    ValidatorWrapper(String keyword, String keywordPath, Validator validator) {
        this.keyword = Objects.requireNonNull(keyword);
        this.keywordPath = Objects.requireNonNull(keywordPath);
        this.validator = Objects.requireNonNull(validator);
    }

    ValidatorWrapper(String keyword, JsonNode keywordNode, Validator validator) {
        this(keyword, keywordNode.getJsonPointer(), validator);
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode instanceNode) {
        return this.validator.validate(ctx, instanceNode);
    }

    @Override
    public int getOrder() {
        return this.validator.getOrder();
    }

    String getKeyword() {
        return this.keyword;
    }

    String getKeywordPath() {
        return this.keywordPath;
    }
}

