/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public final class ValidationContext {
    private final JsonParser jsonParser;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;
    private final LinkedList<URI> dynamicScope;
    private final List<Annotation> annotations;
    private final List<Annotation> validationAnnotations;

    ValidationContext(JsonParser jsonParser, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonParser = jsonParser;
        this.schemaRegistry = schemaRegistry;
        this.schemaResolver = schemaResolver;
        this.dynamicScope = new LinkedList();
        this.annotations = new ArrayList<Annotation>();
        this.validationAnnotations = new ArrayList<Annotation>();
    }

    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public Optional<Schema> resolveSchema(String ref) {
        String resolvedUri = UriUtil.resolveUri(this.dynamicScope.peek(), ref);
        return Optional.ofNullable(this.schemaRegistry.get(resolvedUri)).or(() -> Optional.ofNullable(this.schemaRegistry.getDynamic(resolvedUri))).or(() -> this.resolveExternalSchema(resolvedUri));
    }

    public Optional<Schema> resolveDynamicSchema(String ref) {
        String resolvedUri = UriUtil.resolveUri(this.dynamicScope.peek(), ref);
        if (this.schemaRegistry.get(resolvedUri) != null) {
            return Optional.of(this.schemaRegistry.get(resolvedUri));
        }
        Optional<String> anchor = UriUtil.getAnchor(ref);
        if (anchor.isPresent()) {
            Iterator<URI> it = this.dynamicScope.descendingIterator();
            while (it.hasNext()) {
                Schema schema = this.schemaRegistry.getDynamic(it.next().toString() + "#" + anchor.get());
                if (schema == null) continue;
                return Optional.of(schema);
            }
        }
        return Optional.empty();
    }

    public Schema resolveRequiredSchema(String ref) {
        return Optional.ofNullable(this.schemaRegistry.get(ref)).orElseThrow(() -> new IllegalStateException("Resolution of schema [%s] failed and was required".formatted(ref)));
    }

    boolean isOutOfDynamicScope(URI uri) {
        return this.dynamicScope.isEmpty() || !uri.equals(this.dynamicScope.peek());
    }

    void pushDynamicScope(URI uri) {
        this.dynamicScope.push(uri);
    }

    void popDynamicContext() {
        this.dynamicScope.pop();
    }

    List<Annotation> getValidationAnnotations() {
        return Collections.unmodifiableList(this.validationAnnotations);
    }

    void addValidationAnnotation(Annotation annotation) {
        this.validationAnnotations.add(annotation);
    }

    void truncateAnnotationsToSize(int size) {
        this.annotations.subList(size, this.annotations.size()).clear();
    }

    private Optional<Schema> resolveExternalSchema(String uri) {
        String baseUri = UriUtil.getUriWithoutFragment(uri);
        if (this.schemaRegistry.get(baseUri) != null) {
            return Optional.empty();
        }
        Optional<String> rawJson = this.schemaResolver.resolve(baseUri);
        if (rawJson.isPresent()) {
            try {
                this.jsonParser.parseRootSchema(baseUri, rawJson.get());
                return this.resolveSchema(uri);
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

