/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.ArrayList;
import java.util.List;

class UniqueItemsValidator
implements Validator {
    private final boolean unique;

    UniqueItemsValidator(JsonNode node) {
        if (!node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.unique = node.asBoolean();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isArray() || !this.unique) {
            return ValidationResult.success();
        }
        ArrayList<JsonNode> parsed = new ArrayList<JsonNode>();
        List<JsonNode> jsonNodes = node.asArray();
        for (int i = 0; i < jsonNodes.size(); ++i) {
            JsonNode element = jsonNodes.get(i);
            if (parsed.stream().anyMatch(element::isEqualTo)) {
                return ValidationResult.failure("Array contains non-unique item at index [%d]".formatted(i));
            }
            parsed.add(element);
        }
        return ValidationResult.success();
    }
}

